function loadImage(frame, imageUrl, fallbackImageUrl) {
    var img = new Image();
    img.onload = function() {
        frame.body.innerHTML = '<img src="' + imageUrl + '" style="width:100%;height:100%;">';
        updateButtonState(); // Nachdem das Bild geladen wurde, Button-Status aktualisieren
    };
    img.onerror = function() {
        frame.body.innerHTML = '<img src="' + fallbackImageUrl + '" style="width:100%;height:100%;">';
        updateButtonState(); // Wenn das Bild nicht geladen wurde, Button-Status aktualisieren
    };
    img.src = imageUrl;
}

function checkImageLoaded(imageUrl, callback) {
    var img = new Image();
    img.onload = function() {
        callback(true);
    };
    img.onerror = function() {
        callback(false);
    };
    img.src = imageUrl;
}

function updateButtonState() {
    var num = document.getElementById("searchField").value;
    var imageUrl = 'bibliothek/' + num + '/' + num + '.jpg';

    checkImageLoaded(imageUrl, function(loaded) {
        var button = document.getElementById("openInNewTabBtn");
        button.disabled = !loaded; // Button deaktivieren, wenn Bild nicht geladen wurde
    });
}

function openInNewTab() {
    var num = document.getElementById("searchField").value;
    var imageUrl = 'bibliothek/' + num + '/' + num + '.jpg';
    window.open(imageUrl, '_blank');
}
